/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.cursee.more_bows_and_arrows.core.util;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1671;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_9283;
import net.minecraft.class_9284;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class FireworkUtil {
    public static void createRandomFireworkFromEntity(@NotNull class_1309 owner, class_2338 blockPos) {
        class_1937 class_19372 = owner.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        class_1799 fireworkRocketItem = class_1802.field_8639.method_7854();
        fireworkRocketItem = FireworkUtil.addRandomFireworkData(serverLevel.method_8409(), fireworkRocketItem);
        FireworkUtil.spawnFireworkEntity((class_1937)serverLevel, owner, blockPos, fireworkRocketItem);
    }

    private static void spawnFireworkEntity(class_1937 level, class_1309 owner, class_2338 pos, class_1799 fireworkItem) {
        class_1671 fireworkRocketEntity = new class_1671(owner.method_37908(), (class_1297)owner, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), fireworkItem);
        fireworkRocketEntity.method_24203((double)pos.method_10263(), (double)pos.method_10264() + 1.0, (double)pos.method_10260());
        level.method_8649((class_1297)fireworkRocketEntity);
    }

    private static boolean noFireworkExplosionSet(class_1799 stack) {
        if (stack.method_57824(class_9334.field_49616) == null || stack.method_57353().method_57837()) {
            return false;
        }
        return !stack.method_57353().method_57832(class_9334.field_49616) || !((class_9284)stack.method_57824(class_9334.field_49616)).comp_2392().isEmpty();
    }

    private static class_1799 addRandomFireworkData(class_5819 random, class_1799 stack) {
        class_1799 newRandomFireworkItemStack = stack.method_7972();
        if (FireworkUtil.noFireworkExplosionSet(stack)) {
            ArrayList<class_9283> explosions = new ArrayList<class_9283>();
            class_9283 hardCoded = new class_9283(class_9283.class_1782.field_7970, IntList.of((int)0), IntList.of((int)0), true, true);
            explosions.add(hardCoded);
            class_9284 fireworks = new class_9284(1, explosions);
            class_1799 fireworkRocketItem = class_1802.field_8639.method_7854();
            fireworkRocketItem.method_57379(class_9334.field_49616, (Object)fireworks);
        }
        return newRandomFireworkItemStack;
    }

    private static class_2499 randomExplosions(class_5819 random) {
        class_2499 list = new class_2499();
        list.add((Object)FireworkUtil.randomExplosion(random));
        if (random.method_43056()) {
            for (int i = 0; i < random.method_43048(2) + 1; ++i) {
                list.add((Object)FireworkUtil.randomExplosion(random));
            }
        }
        return list;
    }

    private static class_2487 randomExplosion(class_5819 random) {
        class_2487 EXPLOSION = new class_2487();
        EXPLOSION.method_10572("Colors", FireworkUtil.randomColors(random, 1));
        EXPLOSION.method_10572("FadeColors", FireworkUtil.randomColors(random, 5));
        EXPLOSION.method_10567("Type", (byte)random.method_43048(5));
        int randomFlickerTrail = random.method_43048(10);
        if (randomFlickerTrail == 7 || randomFlickerTrail == 9) {
            EXPLOSION.method_10556("Trail", true);
        }
        if (randomFlickerTrail == 8 || randomFlickerTrail == 9) {
            EXPLOSION.method_10556("Flicker", true);
        }
        return EXPLOSION;
    }

    private static ArrayList<Integer> randomColors(class_5819 random, int probChance) {
        ArrayList<Integer> RANDOM_COLORS = new ArrayList<Integer>();
        RANDOM_COLORS.add(FireworkUtil.randomColor(random));
        for (int i = 0; i < random.method_43048(3); ++i) {
            RANDOM_COLORS.add(FireworkUtil.randomColor(random));
        }
        return RANDOM_COLORS;
    }

    private static int randomColor(class_5819 random) {
        class_1767 DEFAULTED_COLOR = class_1767.field_7952;
        String[] blockedColors = new String[]{class_1767.field_7963.method_7792(), class_1767.field_7944.method_7792(), class_1767.field_7967.method_7792(), class_1767.field_7952.method_7792()};
        class_1767 chosenColor = class_1767.method_7791((int)random.method_43048(class_1767.values().length));
        Set skippedIDSet = Arrays.stream(blockedColors).map(colorName -> class_1767.method_7793((String)colorName, (class_1767)DEFAULTED_COLOR).method_7789()).collect(Collectors.toSet());
        while (skippedIDSet.contains(chosenColor.method_7789())) {
            chosenColor = class_1767.method_7791((int)random.method_43048(class_1767.values().length));
        }
        return chosenColor.method_7790();
    }
}

